*This code import the raw data for the volume and diameter distribution estimation

clear

set more off

clear

cd "C:\Users\Claudio PETUCCO\Documents\"
*cd "F:\"
*cd "G:\"



global dataout "LEF\Dottorato\Case_studies\Chalara\Data\Ash_distribution\"
global dataraw "LEF\Dottorato\Case_studies\Chalara\Data\IGN_Donnees_brutes\Dataraw\"
global dataweib "LEF\Dottorato\Case_studies\Chalara\Data\Ash_distribution\FFSM_input\Weibull\"

/********************************************************************/
*Choose the INF years
/********************************************************************/
*first year
local fy 2006 
*last year
local ly 2010

local fy1=`fy'+1


/********************************************************************/
*importing data and merging
/********************************************************************/

forvalues x = `fy'(1)`ly'{
		*trees data
		clear
		insheet using ${dataraw}arbres_foret_`x'.csv, delimiter(";")

		keep idp c13 espar v w
		g year=`x'

		save ${dataout}trees`x'.dta, replace
		
		*plot data
		clear
		insheet using ${dataraw}placettes_foret_`x'.csv, delimiter(";")

		keep idp xl93 yl93 esspre dep sfo/*cac*/
		
		*merge tree data to plot data
		merge 1:m idp using ${dataout}trees`x'.dta
		
		drop if _m!=3
		
		*Common ahs (fraxinus excelsior)
		g ash_c=1 if espar=="17C"
		/*
		*Fraxinus angustifolia
		g ash_a=1 if espar=="17O" 

		*FRENE A FLEUR (Fraxinus ornus)
		g ash_f=1 if espar=="17F" 
		*/
		keep if ash_c==1
	
		drop _m ash_* espar 
		
		save ${dataout}ash`x'.dta, replace
		
}



/********************************************************************/
* Append
/********************************************************************/
use ${dataout}ash`fy'.dta, clear



forvalues x = `fy1'(1)`ly'{
append using ${dataout}ash`x'
}




#delimit ;
lab def esspre
1	"CHENE INDIFFERENCIE"
2	"CHENE PEDONCULE"
3	"CHENE ROUVRE"
4	"CHENE ROUGE D'AMERIQUE"
5	"CHENE PUBESCENT"
6	"CHENE VERT"
7	"CHENE TAUZIN"
8	"CHENE-LIEGE"
9	"HETRE"
10	"CHATAIGNIER"
11	"CHARME"
12	"BOULEAU"
13	"GRAND AULNE"
14	"ROBINIER FAUX ACACIA"
15	"GRAND ERABLE"
16	"MICOCOULIER"
17	"FRENE"
18	"ORME"
19	"PEUPLIER CULTIVE"
20	"TILLEUL"
21	"PETIT ERABLE"
22	"CERISIER OU MERISIER"
23	"AUTRE FRUITIER"
24	"TREMBLE"
25	"SAULE"
26	"PLATANE"
27	"NOYER"
28	"OLIVIER"
29	"AUTRE FEUILLU EXOTIQUE"
30	"MURIER"
31	"NOISETIER"
32	"CHARME-HOUBLON"
33	"PEUPLIER NON CULTIVE"
34	"CHENE CHEVELU"
35	"TAMARIS"
36	"EUCALYPTUS"
37	"AULNE VERT"
38	"GRAND CYTISE (AUBOUR)"
39	"CORNOUILLER MALE"
40	"ARBOUSIER"
41	"ALISIER TORMINAL"
42	"TULIPIER DE VIRGINIE"
49	"AUTRE FEUILLU INDIGENE"
51	"PIN MARITIME"
52	"PIN SYLVESTRE"
53	"PIN LARICIO"
54	"PIN NOIR"
55	"PIN PIGNON"
56	"PIN WEYMOUTH"
57	"PIN D'ALEP"
58	"PIN A CROCHETS"
59	"PIN CEMBRO"
60	"PIN MUGO"
61	"SAPIN PECTINE"
62	"EPICEA COMMUN"
63	"MELEZE D'EUROPE"
64	"DOUGLAS"
65	"CEDRE DE L'ATLAS"
66	"CYPRES"
67	"IF"
68	"AUTRE CONIFERE EXOTIQUE"
69	"GENEVRIER THURIFERE"
70	"SAPIN MEDITERRANEEN"
71	"SAPIN DE NORDMANN"
72	"SAPIN AMERICAIN"
73	"EPICEA DE SITKA"
74	"MELEZE EXOTIQUE"
75	"AUTRE CONIFERE INDIGENE"
76	"CEDRE DU LIBAN"
77	"PIN A ENCENS";

/*
lab def cac
1	"0-5 ans"
2	"5-10 ans"
3	"10-15 ans"
4	"15-20 ans"
5	"20-25 ans"
6	"25-30 ans"
7	"30-35 ans"
8	"35-40 ans"
9	"40-50 ans"
10	"50-60 ans"
11	"60-70 ans"
12	"70-80 ans"
13	"80-100 ans"
14	"100-120 ans"
15	"120-140 ans"
16	"140-160 ans"
17	"160-180 ans"
18	"180-200 ans"
19	"200-240 ans"
20	">= 240 ans"
99	"ABSENCE D'ARBRES"
999	"PEU RECENSABLE";
*/
#delimit cr

lab val esspre esspre
*lab val agec cac

sort idp


save ${dataout}ashtot.dta, replace



forvalues x = `fy'(1)`ly'{
		erase ${dataout}ash`x'.dta
		erase ${dataout}trees`x'.dta
}


* Export to GIS

g ftype=9

replace ftype=1 if esspre<50 & sfo>=1 & sfo<=2
replace ftype=2 if esspre<50 & sfo==3
replace ftype=3 if esspre<50 & sfo==4
replace ftype=5 if esspre>50

g vol=v*w

rename ftype ftype_plot
keep xl93 yl93 vol w ftype_plot c13

save ${dataweib}weibull_START.dta,replace


outsheet using ${dataweib}weib_start.csv, replace



clear

global datain "LEF\Dottorato\Case_studies\Chalara\Data\Ash_distribution\FFSM_input\Weibull\"
global dataout "MATLAB\Chalara\"

insheet using ${datain}weib_ser.csv, clear

tabulate codeser ftype_plot, summarize(c13)

g d13=c13/_pi
drop c13

drop ser
encode codeser, g(ser)

replace vol=round(vol)
egen trees=count(vol), by(ser)
tab ser if trees<30, sum(trees)


sort ser

order d13 vol ser codeser


outsheet d13 vol ser codeser using ${dataout}weib_estim_START.csv, replace nol


clear
insheet using "C:\Users\Claudio PETUCCO\Documents\MATLAB\Chalara\weib_estim_START.csv"
g newser=ser
replace new=101 if ser==4 | ser==5 | ser==21 | ser==24 | ser==40
replace new=102 if ser==42 | ser==45 | ser==46 | ser==47
replace new=103 if ser==62 | ser==74
replace new=104 if ser==77 | ser==78 | ser==79
replace new=30 if ser==28
replace new=69 if ser==71
replace new=54 if ser==55
drop ser codeser
outsheet using "C:\Users\Claudio PETUCCO\Documents\MATLAB\Chalara\weib_estim_START_FINAL.csv", comma replace
